export default {
    // Target (https://go.nuxtjs.dev/config-target)
    target: 'static',

    ssr: false,
    // Global page headers (https://go.nuxtjs.dev/config-head)
    head: {
        title: 'NEWS',
        meta: [
            { charset: 'utf-8' },
            { name: 'viewport', content: 'width=device-width, initial-scale=1' },
            { hid: 'description', name: 'description', content: '' }
        ],
        link: [
            { rel: 'icon', sizes: '32x32', href: '/icon.png' }
        ]
    },

    // Global CSS (https://go.nuxtjs.dev/config-css)
    css: [],

    // Plugins to run before rendering page (https://go.nuxtjs.dev/config-plugins)
    plugins: [],
    router: {
        base: "/news/"
    },
    // Auto import components (https://go.nuxtjs.dev/config-components)
    components: true,

    // Modules for dev and build (recommended) (https://go.nuxtjs.dev/config-modules)
    buildModules: [],

    // Modules (https://go.nuxtjs.dev/config-modules)
    modules: [
        // https://go.nuxtjs.dev/content
        '@nuxt/content',

        'bootstrap-vue/nuxt',

        '@nuxtjs/i18n',
    ],

    i18n: {
        locales: ['en-GB', 'en-CA', 'en-US', 'fr'],
        defaultLocale: 'en-GB',

    },

    // Content module configuration (https://go.nuxtjs.dev/config-content)
    content: {
        manifest: {
            lang: 'en-GB'
        }
    },

    // Build Configuration (https://go.nuxtjs.dev/config-build)
    build: { publicPath: 'http://localhost/news/', }
}